#!/usr/local/bin/perl
use vars qw($SCRIPT);
($SCRIPT = $0) =~ s!.+/([^/]+$)!$1!;
use CGI::Carp qw(fatalsToBrowser);
use lib './lib';
use strict;
use utf8;
use Encode;
use Encode::Guess qw/ euc-jp shiftjis 7bit-jis utf8 /;
$Encode::Guess::NoUTFAutoGuess = 1; # utf16 utf32 を候補から外す

binmode STDOUT=>":utf8";

my $uid = 1;
use butch;
my $butch = butch->new({'script'=>$SCRIPT, 'dbname'=>sprintf(qq{%05d}, $uid)});

my ( $form, $form_file );
if( $ENV{'CONTENT_TYPE'} =~ m!multipart/form-data! ){
	( $form, $form_file ) = $butch->read_form_multipart(800000,{enc=>'utf8'});
}
else{
	$form = $butch->read_form(20000,{enc=>'utf8'});
}
my $is_login = $butch->check_login($form);
unless( $is_login || $butch->{is_public} ){
	$butch->go_entrance();
}
$butch->page_header({});
# foreach (sort keys %{$form}){printf qq{%s :: %s<br />}, $_, $form->{$_}; }

my $msg;
if($is_login){
	if( $form->{set_profile_btn} eq 'OK'){
		$butch->edit_profile($uid,$form);
	}
	elsif($form->{upload_btn} eq 'OK'){
		$butch->put_user_image($uid,$form_file);
	}
	elsif($form->{delete_btn} eq 'delete'){
		$butch->del_user_image($uid);
	}
	elsif($form->{set_bookstar_btn} eq 'OK'){
		$butch->edit_bookstar($uid,$form);
	}
	elsif($form->{upload_csv_btn} eq 'OK'){
		$msg->{import_by_csv} = $butch->import_book_by_csv($uid, $form_file);
	}
}
my $prof = $butch->get_profile_summary($form);
$butch->disp_header({uid=>$uid, hname=>$prof->{profile}->[0]{hname}, page_title=>$butch->{page_title}->{$butch->{script}}});
$butch->disp_contents({
	primary=>{
		func=>'profile',
		param=>{form=>$form,profile=>$prof}
	  },
	secondary=>{
		func=>'profile_panel',
		param=>{form=>$form,profile=>$prof,err=>$msg,is_login=>$is_login}
	}
});

$butch->disp_footer({uid=>$uid,is_login=>$is_login, op=>$form->{op}});
$butch->page_footer({});
