package butch::page;
use strict;
use utf8;
use Encode;
use Encode::Guess qw/ euc-jp shiftjis 7bit-jis utf8 /;
$Encode::Guess::NoUTFAutoGuess = 1; # utf16 utf32 を候補から外す

sub new{
	my $invocant = shift;
	my $class = ref($invocant) || $invocant;
	my $args = shift;
	my ( $obj )  = bless {
		@_
	}, $class;

	return $obj;
}
#
sub return_top{
	my $self = shift;
	print qq{<p class="link_btn"><a href="index.pl" title="「趣味は読書2」" class="btn">戻る</a></p>};
	1;
}
sub msg_err{
	my $self = shift;
	my $args = shift;
	printf qq{<p class="err_msg">%s</p>}, $args;
	1;
}
sub msg_desc{
	my $self = shift;
	my $args = shift;
	printf qq{<p class="desc_msg">%s</p>}, $args;
	1;
}
sub msg_err_insert_book{
	my $self = shift;
	my $args = shift;
	my $html = '<p class="attention notfound">登録できませんでした</p>';
	$html .= '<p class="attention notfound">';
	if( ref($args) eq 'ARRAY'){
		foreach my $ref ( @{$args} ){
			foreach (keys %{$ref}){
				$html .= sprintf qq{[%s : %s] }, $_, $ref->{$_};
			}
		}
	}
	elsif( ref($args) eq 'HASH' ){
		foreach ( sort keys %{$args} ){
			$html .= sprintf qq{[%s : %s] }, $_, $args->{$_};
		}
	}
	$html .= '</p>';
	print $html;
}
sub put_html{
	my $self = shift;
	my $args = shift;

	my $html =<<HTML;
<dl>
  <dt>「趣味は読書2」</dt>
  <dd>蔵書管理WEB本棚もどき</dd>
  <dd>ISBNで本を登録します。</dd>
  <dd>既読未読、ジャンルづけ、メモなど記入して備忘録にご利用ください。</dd>
  <dt>ログインはこちらからどうぞ</dt>
  <dd class="link_btn"><a href="index.pl" title="「趣味は読書2」ログイン" class="btn">ログイン</a></dd>
</dl>
HTML

	printf qq{<div class="put_html clearfix">%s</div>}, ( $args || $html );
	1;
}
sub about{
	my $self = shift;
	my $args = shift;
	$args->{c} = 'about' if( ! $args->{c} );
	print '<div class="aboutpage">';
	if( -e $self->{root} . $self->{site_static} . $args->{c} . '.html'){
		open(IN, $self->{root} . $self->{site_static} . $args->{c} . '.html' );
		while(<IN>){
			my $line = Encode::decode('utf8', $_);
			$line =~ s!\$\{([^\}]+)\}!sprintf qq{%s}, $args->{var}->{$1}!eg;
			print $line;
		}
		close(IN);
		
	}
	else{
		$self->msg_err('ページが見つかりませんでした。');
	}
	print '</div>';
}
#
sub bookinfo{
	my $self = shift;
	my $args = shift;

	# from ajax --- js_.+.pl
	if( ! $args->{books}->{books}->[0]{title} ){
		$self->msg_err('本が見つかりませんでした。');
		$self->msg_err(sprintf qq{<a href="%s">&raquo;再読み込み</a>}, $self->{home});
		return;
	}
	my $ref = shift(@{$args->{books}->{books}});
	my $image_url = $ref->{image}->{url} ? $ref->{image}->{url} : sprintf qq{%s%s}, $self->{site_images}, $self->{no_image_book}->{file};
	my $image_width = $ref->{image}->{width} ? $ref->{image}->{width} : $self->{no_image_book}->{width};
	my $image_height = $ref->{image}->{height} ? $ref->{image}->{height} : $self->{no_image_book}->{height};
	printf qq{<form action="%s" method="post" id="bookinfo_form">}, $self->{home};
	print '<div id="bookinfo">';
	printf qq{<h2 class="bookshelf_label">本を見る</h2>};
	printf qq{<ul class="clearfix">};
	printf qq{<li class="image"><img src="%s" width="%s" height="%s" alt="%s" /></li>},
	$image_url,$image_width, $image_height, $ref->{title};
	printf qq{<li class="title">『%s』</li>},$ref->{title};
	foreach (@{$args->{books}->{authors}->{$ref->{uid}}->{$ref->{bookid}}}){
		printf qq{<li class="author">%s</li>}, $_->{author};
	}
	print qq{</ul>};
	print qq{<ul class="bookinfo_panel clearfix">};
	printf qq{<li class="checkbox"><input type="checkbox" name="readed" value="1" %s /> 読了</li>}, $ref->{readed} ? 'checked="checked"':'';
	printf qq{<li class="selectbox"><select name="bookstar">};
	foreach (sort {$a<=>$b;} keys %{$args->{books}->{stars}}){
		printf qq{<option value="%s" %s>%s</option>}, $_,
		$ref->{bookstar} == $_ ? 'selected="selected"':'',
		$args->{books}->{stars}->{$_}->{name};
	}
	printf qq{</select></li>};
	if( $args->{is_login} && $args->{uid} == $ref->{uid}){
		printf qq{<input type="hidden" name="uid" value="%s" />}, $args->{uid};
		printf qq{<input type="hidden" name="bookid" value="%s" />}, $ref->{bookid};
		printf qq{<li class="submit_btn delete"><input type="button" name="submit_btn" class="submit attention" value="削除する" onclick="javascript:updatebook('d')"/></li>};
		printf qq{<li class="submit_btn"><input type="button" name="submit_btn" class="submit" value="更新する" onclick="javascript:updatebook('u')"/></li>};
	}
	print qq{</ul>};
	printf qq{<div id="closebookinfo"><a href="%s%s" class="close" >閉じる</a></div>},
	$args->{uid} != $ref->{uid} && $args->{visiter}->{bs} ? $self->{visiter} : $self->{home},
	$args->{uid} != $ref->{uid} && $args->{visiter}->{bs} ? '?bs=' . $args->{visiter}->{bs} : '';
	
	print '</div>';
	printf qq{</form>};

	if( @{$args->{books}->{has_memo}->{$ref->{uid}}->{$ref->{bookid}}} ){
		foreach (@{$args->{books}->{has_memo}->{$ref->{uid}}->{$ref->{bookid}}}){
			my $disp = ($_->{netabare} && $args->{uid} != $ref->{uid}) ? '--- ネタバレ ---' : $_->{comment};
			$disp =~ s!\r?\n!<br />!g;
			printf qq{<div id="bookmemo%d" class="bookmemo clearfix">},$_->{commentid};
			# bolivia.js js_memo.pl
			printf qq{<p %s>%s</p>}, ($_->{netabare} && $args->{uid} != $ref->{uid}) ? 'style="text-align:center;"':'', $disp;
			printf qq{<div class="bookmemo_panel">};
			printf qq{<span><input type="checkbox" name="netabare" value="1" %s/> ネタバレ</span>}, $_->{netabare} ? 'checked="checked"':'';
			if( $args->{is_login} && $args->{uid} == $ref->{uid} ){
				printf qq{<a href="javascript:void(0)" onclick="javascript:editmemoform(\'bookmemo%d\');">&raquo;メモを編集する</a>},$_->{commentid};
			}
			printf qq{</div>};
			# bolivia.js js_memo.pl
			print '</div>';
		}
	}
	if( $args->{is_login} && $args->{uid} == $ref->{uid} && @{$args->{books}->{has_memo}->{$ref->{uid}}->{$ref->{bookid}}} < $self->{memo_max} ){
		printf qq{<div id="bookmemo0" class="bookmemo clearfix">};
		printf qq{<a href="javascript:void(0)" onclick="javascript:addmemoform('%s');" class="add">メモを追加</a>}, $ref->{bookid};
		printf qq{</div>};
	}
}
#
sub bookshelf{
	my $self = shift;
	my $args = shift;

	if( ! @{$args->{books}->{books}} ){
		printf qq{<div id="bookshelf">};
		$self->msg_desc('本が見つかりませんでした。');
		print '</div>';
		return;
	}

	if( ref($args->{err}) ){
		$self->msg_err_insert_book($args->{err});
	}
	$self->pager($args);
	printf qq{<div id="bookshelf">};
	foreach (@{$args->{books}->{books}}){
		my $uid    = $_->{uid};
		my $bookid = $_->{bookid};
		my ($y, $m, $d) = unpack("a4a2a2", $_->{ymd});
		printf qq{<ul class="clearfix" id="bookinfo%s">}, $bookid;
		# ymd
		printf qq{<li class="ymd"><a href="%s?ymd=%s">%s</a>/<a href="%s?ymd=%s%s">%s</a>/%s</li>},
		$self->{script}, $y, $y, $self->{script}, $y,$m, $m, $d;
		# star
		printf qq{<li class="star"><a href="%s?star=%s" title="%s"><span style="color:#%s">%s</span></a></li>},
		$self->{script},$_->{bookstar},
		$args->{books}->{stars}->{$_->{bookstar}}->{name},
		($args->{books}->{stars}->{$_->{bookstar}}->{color} || '999'),
		$args->{books}->{stars}->{$_->{bookstar}}->{str};
		# memo title
		printf qq{<li class="title"><a href="javascript:void(0);" onClick="javascript:viewbook('%s','%s','%s')" title="%s"><img src="%sicon_pen_%s.gif" alt="memo" /> %s</a></li>},
		$_->{uid}, $_->{bookid}, $args->{form}->{bs},$_->{title},
		$self->{site_images}, @{$args->{books}->{has_memo}->{$uid}->{$bookid}} ? 'on':'off',
		$_->{title};
		# authors
		print qq{<li class="authors">};
		my @buf;
		foreach (@{$args->{books}->{authors}->{$uid}->{$bookid}}){
			push(@buf, sprintf qq{<a href="%s?author=%s" title="%s">%s</a>},
				 $self->{script},$self->html_encode($_->{author}),$_->{author},$_->{author});
		}
		printf qq{%s}, join(' ', @buf[0..1]); # 著者はふたりまで表示
		print qq{</li>};
		# readed
		printf qq{<li class="readed"><a href="%s?readed=%s" title="%s"><img src="%sicon_checkbox_%s.gif" alt="readed" /></a></li>},
		$self->{script}, $_->{readed},
		$_->{readed} ? '既読':'未読',
		$self->{site_images}, $_->{readed} ? 'on':'off';
		print '</ul>';
	}
	print '</div>';
	$self->pager($args);
}
sub bookshelf_panel{
	my $self = shift;
	my $args = shift;

	my ($d,$m,$y) = (localtime(time))[3..5]; ++$m; $y+=1900;
	my ($begin_d, $begin_m, $begin_y) = (localtime($args->{books}->{begin}))[3..5]; ++$begin_m; $begin_y+=1900;
	my ($latest_d, $latest_m, $latest_y) = (localtime($args->{books}->{latest}))[3..5]; ++$latest_m; $latest_y+=1900;
	my @buf;
	push(@buf,($begin_y..$latest_y));
	my $script = $self->{home};

	print '<div id="bookshelf_panel">';
	printf qq{<h2 class="bookshelf_label">本棚を見る</h2>};
	print qq{<ul class="clearfix">};
	printf qq{<li class="one underline head"><a href="%s" title="再読み込み" id="reload_bookshelf">再読み込み</a>%s</li>},
	$script,
	$args->{form}->{op} eq 'd' ? '<br /><span class="note">本の変更を反映する</span>':'';

	printf qq{<li class="two underline head"><a href="%s?readed=1" title="既読">既読</a></li>}, $script;
	printf qq{<li class="two underline head"><a href="%s?readed=0" title="未読">未読</a></li>}, $script;
	print qq{<li class="one underline">};
	printf qq{<form action="%s" method="post">}, $script;
	print qq{<select name="_year"><option value="">----</option>};
	foreach( reverse( @buf ) ){
		printf qq{<option value="%s" %s>%s</option>}, $_, $args->{form}->{_year} == $_ ? 'selected="selected"':'', $_;
	}
	print qq{</select>年};
	print qq{ <select name="_month"><option value="">--</option>};
	foreach (1..12){
		printf qq{<option value="%s" %s>%s</option>}, $_, $args->{form}->{_month} == $_ ? 'selected="selected"':'' , $_;
	}
	print qq{</select>月};
	print qq{ <input type="submit" name="submit_btn" value="OK" />};
	print qq{</form>};
	print qq{</li>};

	print qq{<li class="one underline">};
	print qq{<ol class="clearfix">};
	my $cnt;
	foreach (sort {$a<=>$b;} keys %{$args->{books}->{stars}}){
		next if ! $_;
		printf qq{<li class="two %s">}, ++$cnt%2 ? 'odd':'even';
		printf qq{<a href="%s?star=%s" title="%s"><span style="color:#%s">%s</span> %s</a>},
		$script,$_,
		$args->{books}->{stars}->{$_}->{name},
		$args->{books}->{stars}->{$_}->{color},$args->{books}->{stars}->{$_}->{str},$args->{books}->{stars}->{$_}->{name};
		print qq{</li>};
	}
	printf qq{<li class="two %s">}, , ++$cnt%2 ? 'odd':'even';
	printf qq{<a href="%s?star=0" title="%s"><span style="color:#%s">%s</span> %s</a>},
	$script,
	$args->{books}->{stars}->{0}->{name},
	$args->{books}->{stars}->{0}->{color},$args->{books}->{stars}->{0}->{str},$args->{books}->{stars}->{0}->{name};
	print qq{</li>};
	print qq{</ol>};
	print qq{</li>};

	$args->{form}->{search} =~ s!\%! !g if $args->{form}->{search};
	print qq{<li class="one">};
	printf qq{<form action="%s" method="post">}, $script;
	print qq{<dl>};
	printf qq{<dt>検索: <input type="text" name="search" value="%s" /></dt>}, $args->{form}->{search};
	printf qq{<dd><input type="radio" name="col" value="title"  %s />タイトル }, (! $args->{form}->{col} || $args->{form}->{col} eq 'title') ? 'checked="checked"':'';
	printf qq{<input type="radio" name="col" value="author" %s />著者 }, $args->{form}->{col} eq 'author' ? 'checked="checked"':'';
	printf qq{<input type="radio" name="col" value="memo"   %s />メモ }, $args->{form}->{col} eq 'memo' ? 'checked="checked"':'';
	printf qq{<input type="radio" name="col" value="isbn"   %s />ISBN</dd>}, $args->{form}->{col} eq 'isbn' ? 'checked="checked"':'';
	print qq{<dd><input type="submit" name="submit_btn" value="OK" /></dd>};
	print qq{</dl>};
	print qq{</form>};
	print qq{</li>};

	print qq{</ul>};
	print '</div>';
}
#
sub bookshelf_empty{
	my $self = shift;
	my $args = shift;

	print <<HTML;
<dl id="bookshelf">
  <dt>本棚にまだ本が入ってません</dt>
    <dd>
	  ISBNを入力して「本棚に入れる」ボタンをクリックするだけで本を入れられます。
    </dd>
    <dd>
	  本棚に入れた本は、既読未読のチェック、ジャンルやメモの記入ができます。
    </dd>
	<dd>
	  本を買ったら・借りたら、とりあえず、本棚に入れておきませんか？
    </dd>
</dl>
HTML
}
sub bookshelf_desc{
	my $self = shift;
	my $args = shift;

	print <<HTML;
<dl id="bookshelf_desc" class="put_html">
  <dt>本棚の表示</dt>
	<dd>
	  「日付 ジャンル メモ タイトル 著者 既読」
	</dd>
  <dt>日付</dt>
	<dd>
	  変更のあった日付です(登録した日、読了チェックをした日、メモをつけた日など)<br />
	  年の部分をチェックするとその年の本を、月の部分をチェックするとその年のその月の本を一覧します。
	</dd>
  <dt>ジャンル</dt>
	<dd>
	  プロフィール画面で設定したジャンルの記号を表示します。設定していない場合は<span style="color:#ccc">■</span>を表示します。<br />
	  ジャンルをクリックすると、そのジャンルの本を一覧します。
	</dd>
  <dt>メモ</dt>
	<dd>
	  メモがあれば <img src="./bolivia/css/images/icon_pen_on.gif" alt="メモあり" />、なければ <img src="./bolivia/css/images/icon_pen_off.gif" alt="メモなし" />を表示します。
	</dd>
  <dt>タイトル</dt>
	<dd>
	  タイトルをクリックすると、ここに本の編集画面を表示します。<br />
	  タイトルや著者の読みを入力、ジャンルをチェック、読了チェックなどができます。メモを記入することもできます(内容がネタバレかな、と思ったらネタバレチェックを入れることもできます)
	</dd>
  <dt>著者</dt>
	<dd>
	  著者名をクリックすると、その著者の本を一覧します。
	</dd>
  <dt>既読</dt>
	<dd>
	  既読 <img src="./bolivia/css/images/icon_checkbox_on.gif" alt="既読" />、未読 <img src="./bolivia/css/images/icon_checkbox_off.gif" alt="既読" />をクリックすると、既読、未読の本を一覧します。
	</dd>
</dl>
HTML
}
#
sub pager{
	my $self = shift;
	my $args = shift;

	my $maxpage = int($args->{books}->{maxcount} / $self->{page_limit});
	++$maxpage if ($args->{books}->{maxcount} % $self->{page_limit});

	my $p = int($args->{form}->{page} / $self->{pager_page}) * $self->{pager_page};

	my $current = 0;
	my @buf;
	foreach (keys %{$args->{form}}){
		$current = $args->{form}->{$_}, next if $_ eq 'page';
		next if /submit/; # post の名残りは外す
		next if /^_.+/; # post の名残りは外す _isbn _readed _amazon
		next if /^from_amazon/; # post の名残りは外す
		next if $_ eq 'bs'; # bs は下でつける
		push(@buf, sprintf qq{%s=%s},$_, $self->html_encode($args->{form}->{$_}));
	}
	my $param = join('&amp;', @buf);
	my $v_param = ($args->{form}->{bs} == $args->{books}->{books}->[0]{uid} && $args->{form}->{bs} =~ /^\d+$/) ? '&amp;bs=' . $args->{form}->{bs} : '';
	$param .= $v_param;

	print '<div class="pager clearfix">';
	printf qq{<a href="%s?page=0%s" title="1頁に戻る" class="disp_page">%d / %d</a>},
	$self->{script},$param ? '&amp;' . $param : '',
	$args->{books}->{maxcount},$args->{books}->{allcount};
	if($p * $self->{pager_page} > $self->{pager_page} ){
		printf qq{<a href="%s?page=%d%s" class="nextpage">前頁</a>},
		$self->{script},
		$p - 1,
		$param ? '&amp;' . $param : '';
	}
	for (my $i = $p; $i < ($p + $self->{pager_page}); $i++){
		last if $i >= $maxpage;
		if($current == $i){
			printf qq{<span class="page current">%d</span>}, $i+1;
		}
		else{
			printf qq{<a href="%s?page=%d%s" class="page">%d</a>},
			$self->{script},$i,$param ? '&amp;' . $param : '', $i+1;
		}
	}
	if($p < $maxpage && $args->{books}->{maxcount} > $self->{page_limit} * $self->{pager_page}){
		printf qq{<a href="%s?page=%d%s" class="nextpage">次頁</a>},
		$self->{script},
		($p + $self->{pager_page}),
		$param ? '&amp;' . $param : '';
	}
	print '</div>';
	return;
}
# profile
sub profile{
	my $self = shift;
	my $args = shift;

	my $total = $args->{profile}->{readed}->[0]{cnt} + $args->{profile}->{readed}->[1]{cnt};
	print '<div id="profile">';
	print qq{<ul class="clearfix">};

	my $readed;
	foreach ( @{$args->{profile}->{readed}} ){
		$readed->{$_->{readed}} = $_->{cnt};
	}
	printf qq{<li class="one head underline"><a class="main_digi" href="%s" title="本棚を見る">%d</a><br />登録冊数</li>}, $self->{index},$total;
	printf qq{<li class="two head underline"><a class="sub_digi" href="%s?readed=1" title="既読">%0.1f%%</a><br />既読(%d)</li>},
	$self->{index},$total ? ($readed->{1} / $total) * 100 : $total, $readed->{1};
	printf qq{<li class="two head underline"><a class="sub_digi" href="%s?readed=0" title="未読">%0.1f%%</a><br />未読(%d)</li>},
	$self->{index},$total ? ($readed->{0} / $total) * 100 : $total, $readed->{0};

	print qq{<li class="one underline">};
	print qq{<ol class="clearfix">};
	my $cnt;
	foreach (@{$args->{profile}->{bookstar}}){
		$cnt->{$_->{bookstar}} = $_->{cnt};
	}
	for(my $n=1; $n<=10; $n++){
		printf qq{<li class="two %s">}, $n%2 ? 'odd':'even';
		printf qq{<a class="sub_digi" href="%s?star=%d" title="%s">%0.1f%%</a><span style="color:#%s">%s</span> %s(%d)},
		$self->{index},$n,$args->{profile}->{stars}->[$n]{starname},
		$total ? ($cnt->{$n} / $total) * 100 : $total,
		$args->{profile}->{stars}->[$n]{starcolor},
		$args->{profile}->{stars}->[$n]{starstr},
		$args->{profile}->{stars}->[$n]{starname},
		$cnt->{$n};
		print qq{</li>};
	}
	printf qq{<li class="two odd">};
	printf qq{<a class="sub_digi" href="%s?star=0" title="%s">%0.1f%%</a><span style="color:#%s">%s</span> %s(%d)},
	$self->{index},$args->{profile}->{stars}->[0]{starname},
	$total ? ($cnt->{0} / $total) * 100 : $total,
	$args->{profile}->{stars}->[0]{starcolor},
	$args->{profile}->{stars}->[0]{starstr},
	$args->{profile}->{stars}->[0]{starname}, # bookstar ---> start0 1
	$cnt->{0}; # order by bookstar  ---> start0 0
	print qq{</li>};
	print qq{</ol>};
	print qq{</li>};

	print qq{<li class="one ">};
	print qq{<ol class="clearfix">};
	for(my $n=0; $n<10; $n++){
		printf qq{<li class="two %s">}, $n%2 ? 'even':'odd';
		printf qq{<a class="sub_digi" href="%s?author=%s" title="%s">%0.1f%%</a>%s(%s)},
		$self->{index},$self->html_encode($args->{profile}->{authors}->[$n]{author}),$args->{profile}->{authors}->[$n]{author},
		$total ? ($args->{profile}->{authors}->[$n]{cnt} / $total) * 100 : $total,
		$args->{profile}->{authors}->[$n]{author},
		$args->{profile}->{authors}->[$n]{cnt};
		print qq{</li>};
	}
	print qq{</ol>};
	print qq{</li>};

	print qq{</ul>};
	print '</div>';
}
sub profile_panel{
	my $self = shift;
	my $args = shift;

	print '<div id="profile_panel">';
	print qq{<ul class="clearfix">};

	print qq{<li class="one head">};
	print qq{<dl class="set_profile clearfix">};
	printf qq{<dt>名前</dt>};
	printf qq{<dd><input type="text" name="hname" value="%s" size="20" /></dd>}, $args->{form}->{hname} ? $args->{form}->{hname} : $args->{profile}->{profile}->[0]{hname} ? $args->{profile}->{profile}->[0]{hname} : '';
	print qq{</dd></dl>};
	print qq{<p class="set_bookstar">カテゴリの設定</p>};
	printf qq{<form action="%s" method="post">}, $self->{profile};
	foreach (@{$args->{profile}->{stars}}){
		next if ! $_->{starid};
		print qq{<dl class="set_bookstar clearfix">};
		printf qq{<dt>No.%d</dt>}, $_->{starid};
		printf qq{<dd><input type="text" name="starname%d" value="%s" class="starname" /></dd>},
		$_->{starid},($_->{starname} || 'カテゴリ' . $_->{starid});
		printf qq{<dd><input type="text" name="starstr%d"  value="%s" class="starstr" /></dd>},
		$_->{starid},($_->{starstr} || '■');
		printf qq{<dd><input type="text" name="starcolor%d" value="%s" class="starcolor" /></dd>},
		$_->{starid},($_->{starcolor} || '999999');
		print qq{</dl>};
	}
	printf qq{<div class="submit_btn"><input type="submit" name="set_bookstar_btn" value="OK" /></div>} if $args->{is_login};
	print qq{</form>};
	print qq{</li>};

	print qq{</ul>};
	print '</div>';
}
#
sub disp_contents{
	my $self = shift;
	my $args = shift;

	printf qq{<div id="contents" class="clearfix">};
	printf qq{<div id="primary">};
	if( $args->{primary}){
		eval ('$self->' . $args->{primary}->{func} . '($args->{primary}->{param})');
		if($@){
			printf qq{<p class="attention">Error %s : %s</p>}, $args->{primary}->{func}, $@;
		}
	}
	if( $self->{script} eq $self->{entrance} ){
		print '<div id="show_window">';
		if( -e $self->{root} . $self->{site_static} . $self->{whatsnew} ){ # news
			no strict 'refs';
			my $fh = 'FH000';
			++$fh if fileno($fh);
			my @news;
			open($fh, $self->{root} . $self->{site_static} . $self->{whatsnew} );
			while(<$fh>){
				next if /^\#/;
				next if /^\n$/;
				my $line = Encode::decode('utf8', $_);
				push(@news, $line);
			}
			close($fh);
			if( @news ){
				print qq{<div id="whatsnew">};
				print qq{<p class="head">【News】</p>};
				print @news;
				print qq{</div>};
			}
		}
		print qq{<div id="toppage_banner"></div>};
		print '</div>';
	}
	print '</div>';

	printf qq{<div id="secondary" class="secondary0"><div id="display">};
	if( $args->{secondary} ){
		eval ('$self->' . $args->{secondary}->{func} . '($args->{secondary}->{param})');
		if($@){
			printf qq{<p class="attention">Error %s : %s</p>}, $args->{secondary}->{func}, $@;
		}
	}
	print '</div></div>';
	print '</div>';
}
sub disp_header{
	my $self = shift;
	my $args = shift;
	my $uid = $args && $args->{uid} ? $args->{uid} : '';
	my $page_title = $args && $args->{page_title} ? $args->{page_title} . ' 趣味は読書2' : '趣味は読書2';
	my $hname      = $args && $args->{hname} ? $args->{hname} : 'no name';
	print <<HTML;
<div id="header">
  <div id="information">
	<h1><a href="index.pl" title="$page_title">$page_title</a></h1>
    <span id="clock"></span>
    <span id="hname">$hname</span>
  </div>
  <div id="navi">
HTML
if( $uid ){
	print '<ul id="header_link">';
	if($self->{script} ne $self->{profile}){
		printf qq{<li class="link active">本棚</li>};
	}
	else{
		printf qq{<li class="link"><a href="%s" title="本棚">本棚</a></li>}, $self->{index};
	}
	if($self->{script} eq $self->{profile}){
		printf qq{<li class="link active">プロフィール</li>};
	}
	else{
		printf qq{<li class="link"><a href="%s" title="プロフィール">プロフィール</a></li>}, $self->{profile};
	}
	print '</ul>';

	if( $self->{script} eq $self->{index} && $args->{is_login} ){
		print <<HTML;
	<form action="$self->{script}" method="post">
	  <ul id="header_form" class="clearfix">
		<li class="head">ISBN:</li>
		<li class="isbn"><input type="text" name="_isbn" value="" /></li>
		<li class="checkbox"><input type="checkbox" name="_readed" value="1" /> 既読</li>
		<li class="submit"><input type="submit" name="submit_btn" value="本棚に入れる" /></li>
	  </ul>
	</form>
HTML
	}
}
	print <<HTML;
  </div>
</div>
HTML
}
sub disp_footer{
	my $self = shift;
	my $args = shift;
	my ($d,$m,$y) = (localtime(time))[3..5]; ++$m; $y+=1900;
	print <<HTML;
<div id="footer">
  <ul class="clearfix">
HTML
  if($args->{is_login}){
	  printf qq{<li><a href="$self->{index}?op=logout" title="ログアウト">&raquo;ログアウト</a></li>};
	  printf qq{<li><a href="$self->{index}?op=reset_login" title="パスワード変更">&raquo;パスワードリセット</a></li>};
	  printf qq{<li><a href="backup.pl" title="本棚をダウンロード" target="_blank">&raquo;本棚ダウンロード</a></li>};
	  printf qq{<li><a href="backup2.pl" title="本棚をダウンロード" target="_blank">&raquo;本棚ダウンロード2</a></li>};
  }
  elsif( $args->{op} ne 'login' ){
	  printf qq{<li><a href="$self->{index}?op=login" title="トップページ">&raquo;ログイン</a></li>};
  }
  print qq{</ul>};
  print qq{</div>};
}
#
sub page_header{
	my $self = shift;
	my $args = shift;

	my $body_id    = $args && $args->{body_id} ? $args->{body_id} : 'default';
	my $page_title = 'My本棚';

	print "Content-type:text/html\n\n";
	print qq{
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="cache-control" content="no-cache" />
<title>$page_title</title>
<meta name="Description" content="蔵書管理、読書記録に。" />
<meta name="Keywords" content="蔵書管理,読書記録" />
<meta http-equiv="content-style-type" content="text/css" />
<meta http-equiv="content-script-type" content="text/javascript" />
<meta name="viewport" content="width=device-width" />
<script type="text/javascript" src="./bolivia/js/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src="./bolivia/js/bolivia.js"></script>
<link rel="stylesheet" href="./bolivia/css/import.css" type="text/css" media="screen,projection,print" />
};
	print qq{
</head><body id="$body_id"><a id="top" name="top"></a><div id="wrap">
<noscript><p class="attention noscript">javascript を ON にしてください。</p></noscript>
};
	1;
}
sub page_footer{
	my $self = shift;
	my $args = shift;
	print qq{
</div></body></html>
};
	1;
}

#
sub page_header_ajax{
	my $self = shift;

	print "Content-type:text/html\n\n";
	print qq{
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="cache-control" content="no-cache" />
<title>My本棚</title>
<meta name="Description" content="My本棚" />
<meta name="Keywords" content="My本棚" />
<meta http-equiv="content-style-type" content="text/css" />
<meta http-equiv="content-script-type" content="text/javascript" />
</head>
<body>
};

	1;
}
sub page_footer_ajax{
	my $self = shift;
	my $args = shift;
	return;
	print qq{
</body></html>
};
	1;
}

sub DESTROY {
	my $self = shift;
}
1;
__END__

