package butch::misc;
use strict;
use utf8;
use Encode;
use Encode::Guess qw/ euc-jp shiftjis 7bit-jis utf8 /;
$Encode::Guess::NoUTFAutoGuess = 1; # utf16 utf32 を候補から外す

sub new{
	my $invocant = shift;
	my $class = ref($invocant) || $invocant;
	my $args = shift;
	my ( $obj )  = bless {
		%$args,
		@_
	}, $class;
	return $obj;
}
sub DESTROY {
	my $self = shift;
}
sub check_isbn{
	my $self = shift;
	my $isbn = shift;
	$isbn =~ s/\-//g; $isbn =~ s/^ISBN//ig;
	$isbn =~ s/０/0/g; $isbn =~ s/１/1/g; $isbn =~ s/２/2/g; $isbn =~ s/３/3/g; $isbn =~ s/４/4/g;
	$isbn =~ s/５/5/g; $isbn =~ s/６/6/g; $isbn =~ s/７/7/g; $isbn =~ s/８/8/g; $isbn =~ s/９/9/g;
	$isbn =~ s/ //g;

	# B.+ for used books number
	return $isbn if $isbn =~ m!^B[A-Z0-9]+! && length($isbn) == 10;

	# isbn 13keta --> 10keta
	my $dig;
	my $isbn_type;
	if( $isbn =~ /^978/ && length($isbn) == 13 ){
		$isbn_type = 13;
		$dig = chop($isbn);
		my @buf = split('', $isbn);
		my $odd; my $eve;
		for ( my $i = 1; $i <= length($isbn); $i++ ){
			if( $i%2 ){
				$odd += $buf[$i-1]; # 奇数
			}
			else{
				$eve += $buf[$i-1]; # 偶数
			}
		}
		$eve = $eve * 3;
		my $sum = $eve + $odd;
		my $check = chop( $sum );
		$check = 10-$check if( $check );
		return 0 if $check ne $dig;
		$isbn =~ s/^978//;
	}
	else{
		$isbn_type = 10;
		$dig = chop($isbn);
	}
	return 0 if( length($isbn) != 9 );

	my @buf = split('', $isbn);
	my $w = 10;
	my $sum = 0;
	foreach ( @buf ){ $sum += $_ * $w; --$w; }
	my $check = ( 11-($sum % 11) );
	$check = $check == 10 ? 'X' : $check == 11 ? '0' : $check;

	if( $isbn_type == 10 ){
		if( $check ne $dig ){ return 0; }else{ return $isbn . $dig; }
	}
	elsif( $isbn_type == 13 ){
		return $isbn . $check;
	}
}
sub unixtime{
	my $self = shift;
	my $ymd  = shift;
	return if (! $ymd->{y} || ! $ymd->{m} || ! $ymd->{d});
	my $timestamp = (($self->total_days({y=>$ymd->{y}, m=>$ymd->{m}, d=>$ymd->{d}}) - $self->total_days({y=>1970, m=>1, d=>1})) * 60 * 60 * 24) + ($ymd->{h} * 60 * 60) + ($ymd->{mi} * 60) + $ymd->{s};
	$timestamp -= (9 * 60 * 60);
	return $timestamp;
}
sub total_days{
	my $self = shift;
	my $ymd  = shift;

	return if (! $ymd->{y} || ! $ymd->{m} || ! $ymd->{d});

	my @days = ('',
		'31', '28', '31', '30', '31', '30', '31',
		'31', '30', '31', '30', '31'
	);
	$days[2] = 29
	  if( $ymd->{y} % 4 ==0 && ($ymd->{y} % 100 != 0 || $ymd->{y} % 400 != 0 ) );
	return @days if($ymd->{d} eq 'check');

	my $y = $ymd->{y}-1;
	my $d = 365 * $y + int($y/4) - int($y/100) + int($y/400);

	return if $days[$ymd->{m}] < $ymd->{d};

	for( my $i=1; $i < $ymd->{m}; $i++){
		$d += $days[$i];
	}
	$d = $d + $ymd->{d} -1;
	return $d;
}
sub check_mail_by_regex{
	my $self = shift;
	my $args = shift;

	$args->{addr0} =~ s/[ \t]//g;
	$args->{addr1} =~ s/[ \t]//g;
	my $mail_regex =
	q{(?:[-!#-'*+/-9=?A-Z^-~]+(?:\.[-!#-'*+/-9=?A-Z^-~]+)*|"(?:[!#-\[\]-} .
	q{~]|\\\\[\x09 -~])*")@[-!#-'*+/-9=?A-Z^-~]+(?:\.[-!#-'*+/-9=?A-Z^-~]+} .
	q{)*};
	return ( $args->{addr0} eq $args->{addr1} && $args->{addr0} =~ /$mail_regex/ ) ? 1 : 0;
}

1;
