#!/usr/local/bin/perl
use vars qw($SCRIPT);
($SCRIPT = $0) =~ s!.+/([^/]+$)!$1!;
use CGI::Carp qw(fatalsToBrowser);
use lib './lib';
use strict;
use utf8;
use Encode;
use Encode::Guess qw/ euc-jp shiftjis 7bit-jis utf8 /;
$Encode::Guess::NoUTFAutoGuess = 1; # utf16 utf32 を候補から外す

binmode STDOUT=>":utf8";

my $uid = 1;
use butch;
my $butch = butch->new({'script'=>$SCRIPT,'dbname'=>sprintf(qq{%05d}, $uid)});

my $form = $butch->read_form(20000,{enc=>'utf8'});
my $is_login = $butch->check_login($form);
unless( $is_login || $butch->{is_public} ){
	exit;
}

$butch->page_header_ajax;
#foreach (keys %{$form}){printf qq{%s :: %s<br />}, $_, $form->{$_}; }
if( $is_login ){
	if($form->{uid} == $uid && $form->{bookid} =~ /^\d+$/ && $form->{op} =~ /^(u|d|mi|mu)$/){
		if($form->{op} eq 'u'){
			$butch->update_bookinfo($form);
		}
		elsif($form->{op} eq 'd'){
			$butch->delete_bookinfo($form);
		}
		elsif( $form->{op} eq 'mi' ){
			$butch->insert_memo({uid=>$uid, bookid=>$form->{bookid},comment=>$form->{comment},netabare=>$form->{netabare}});
		}
		elsif( $form->{op} eq 'mu' ){
			$butch->update_memo({commentid=>$form->{commentid},comment=>$form->{comment},netabare=>$form->{netabare}});
		}
	}
}
my $books= $butch->list_books($form);
if( $form->{bookid} =~ /^\d+$/ && $form->{op} ne 'd'){
	$butch->bookinfo({uid=>$uid, books=>$books, is_login=>$is_login});
}
else{
	$butch->bookshelf_panel({form=>$form,books=>$books, is_login=>$is_login});
}
$butch->page_footer_ajax;
