#!/usr/local/bin/perl
use vars qw($SCRIPT);
($SCRIPT = $0) =~ s!.+/([^/]+$)!$1!;
use CGI::Carp qw(fatalsToBrowser);
use lib './lib';
use strict;
use utf8;
use Encode;
use Encode::Guess qw/ euc-jp shiftjis 7bit-jis utf8 /;
$Encode::Guess::NoUTFAutoGuess = 1; # utf16 utf32 を候補から外す

binmode STDOUT=>":utf8";
my $uid = 1;
use butch;
my $butch = butch->new({'script'=>$SCRIPT,'dbname'=>sprintf(qq{%05d}, $uid)});

my $form = $butch->read_form(20000,{enc=>'utf8'});
my $is_login = $butch->check_login($form);
unless( $is_login ){
	exit;
}

$butch->page_header_ajax;
#foreach (keys %{$form}){printf qq{%s :: %s<br />}, $_, $form->{$_}; }

if( $form->{op} =~ /^[dc]$/ ){ # d:delete memo c:back --- 追加と更新は js_view_book.pl に変更 i:new memo u:update memo 
	
	if( $form->{op} eq 'd'){
		$form->{bookid} = $butch->delete_memo({commentid=>$form->{commentid}});
		# page.pm bookinfo に同じ
		printf qq{<div id="bookmemo0" class="bookmemo clearfix">};
		printf qq{<a href="javascript:void(0)" onclick="javascript:addmemoform('%s');" class="add">メモを追加</a>}, $form->{bookid};
		printf qq{</div>};
	}
	else{
		my $memo = $butch->get_memo({commentid=>$form->{commentid}});
		my $disp = $memo->[0]{comment}; $disp =~ s!\r?\n!<br />!g;
		printf qq{<p>%s</p>}, $disp;
		printf qq{<div class="bookmemo_panel">};
		printf qq{<span><input type="checkbox" name="netabare" value="1" %s/> ネタバレ</span>}, $memo->[0]{netabare} ? 'checked="checked"':'';
		printf qq{<a href="javascript:void(0)" onclick="javascript:editmemoform(\'bookmemo%d\');">&raquo;メモを編集する</a>},$memo->[0]{commentid};
	}
}
elsif( $form->{op} eq 'new'){
	printf qq{<form id="addmemo" action="%s" method="post">}, $butch->{script};
	print '<div>';
	printf qq{<textarea name="comment"></textarea>};
	printf qq{<div class="bookmemo_panel">};
	printf qq{<span><input type="checkbox" name="netabare" value="1" %s /> ネタバレ</span>};
	printf qq{ <a href="javascript:void(0)" onclick="closebookinfocont('%s')" class="close" title="閉じる">&raquo;閉じる</a>}, $form->{bookid};
	printf qq{ <input type="button" name="insert" class="submit" value="追加する" onclick="updatebook('mi')" />};
	printf qq{</div>};
	print '</div>';
	printf qq{<input type="hidden" name="uid" value="%s" />}, $uid;
	printf qq{<input type="hidden" name="bookid" value="%s" />}, $form->{bookid};
	print '</form>';
}
elsif( $form->{op} eq 'close'){
	my $memos = $butch->select_data( $butch->get_memos({uid=>$uid, bookid=>$form->{bookid}}) );
	if( ref($memos) eq 'ARRAY' && @{$memos} < 3 ){
		printf qq{<a href="javascript:void(0)" onclick="javascript:addmemoform('%s');" class="add">メモを追加</a>}, $form->{bookid};
	}
}
else{
	my( $cssid, $commentid ) = $form->{id} =~ m!(bookmemo)(\d+)!;
	my $memo= $butch->get_memo({commentid=>$commentid});

	printf qq{<form id="memo%s" action="%s" method="post">}, $commentid,$butch->{script};
	print '<div>';
	printf qq{<textarea style="width:%spx; height:%spx" name="comment">%s</textarea>},
	$form->{w}, $form->{h2}, $memo->[0]{comment};
	printf qq{<div class="bookmemo_panel" style="height:%spx">}, ($form->{h1} - $form->{h2});
	printf qq{<span><input type="checkbox" name="netabare" value="1" %s /> ネタバレ</span>}, $memo->[0]{netabare} ? 'checked="checked"':'';
	printf qq{ <input type="button" name="cancel" class="submit" value="戻る" onclick="updatememo('c','%s')" />}, $commentid;
	printf qq{ <input type="button" name="delete" class="submit attention" value="削除する" onclick="updatememo('d','%s')" />},$commentid;
	printf qq{ <input type="button" name="update" class="submit" value="更新する" onclick="updatebook('mu','memo%s')" />},$commentid;
	printf qq{</div>};
	print '</div>';
	printf qq{<input type="hidden" name="commentid" value="%s" />}, $commentid;
	printf qq{<input type="hidden" name="uid" value="%s" />}, $memo->[0]{uid};
	printf qq{<input type="hidden" name="bookid" value="%s" />}, $memo->[0]{bookid};
	print '</form>';
}

$butch->page_footer_ajax;
