#!/usr/local/bin/perl
use vars qw($SCRIPT);
($SCRIPT = $0) =~ s!.+/([^/]+$)!$1!;
use CGI::Carp qw(fatalsToBrowser);
use lib './lib';
use strict;
use utf8;
use Encode;
use Encode::Guess qw/ euc-jp shiftjis 7bit-jis utf8 /;
$Encode::Guess::NoUTFAutoGuess = 1; # utf16 utf32 を候補から外す

binmode STDOUT=>":utf8";

my $uid = 1;
use butch;
my $butch = butch->new({'script'=>$SCRIPT, 'dbname'=>sprintf(qq{%05d}, $uid)});
my $form = $butch->read_form(20000,{enc=>'utf8'});

my $is_login = $butch->check_login($form);
$butch->page_header({});
#printf qq{login: %s<br />public: %s}, $is_login, $butch->{is_public};
if( $form->{op} eq 'login' && ! $is_login ){
	$butch->disp_header({page_title=>$butch->{page_title}->{$butch->{script}}, is_login=>$is_login});
	$butch->disp_contents({
		primary=>{
			func=>'login_form',
			param=>{c=>'bookshelf_empty'}
		  },
		secondary=>{
			func=>'bookshelf_desc',
			param=>''
		}
	});
	$butch->disp_footer({is_login=>$is_login, op=>$form->{op}});
	$butch->page_footer({});
	exit;
}
my $check_msg;
if( $is_login && $form->{submit_btn} eq '本棚に入れる' && $form->{_isbn}){
	$check_msg = $butch->import_book($uid,$form);
}
my $prof = $butch->get_prof;
$butch->disp_header({uid=>$uid, hname=>$prof->[0]{hname}, page_title=>$butch->{page_title}->{$butch->{script}}, is_login=>$is_login});
my $books= $butch->list_books($form);
if( ! $books->{maxcount} && ! $form->{search} ){
	$butch->disp_contents({
		primary=>{
				func=>'about',
			param=>{c=>'bookshelf_empty'}
		  },
		secondary=>{
			func=>'bookshelf_desc',
			param=>''
		}
	});
}
else{
	$butch->disp_contents({
		primary=>{
			func=>'bookshelf',
			param=>{form=>$form,books=>$books,err=>$check_msg}
		  },
		secondary=>{
			func=>'bookshelf_panel',
			param=>{form=>$form,books=>$books,profile=>$prof}
		}
	});
}


$butch->disp_footer({uid=>$uid, is_login=>$is_login});
$butch->page_footer({});
